/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.network.BaseWlanAdapter;
import jpcsp.network.IWlanAdapter;
import jpcsp.network.protocols.EtherFrame;
import jpcsp.scheduler.Scheduler;
import jpcsp.util.Utilities;

public class AsyncWlanAdapter
extends BaseWlanAdapter {
    private IWlanAdapter wlanAdapter;
    private final Object wlanReceiverLock = new Object();
    private final List<byte[]> receivedWlanPackets = new LinkedList<byte[]>();
    private WlanPacketsReceiverThread wlanPacketsReceiverThread;
    private static final int maxReceivedWlanPacketsSize = 0;
    private final Object gameModeReceiverLock = new Object();
    private final List<byte[]> receivedGameModePackets = new LinkedList<byte[]>();
    private final List<pspNetMacAddress> receivedGameModeMacAddresses = new LinkedList<pspNetMacAddress>();
    private GameModePacketsReceiverThread gameModePacketsReceiverThread;
    private final Object wlanSenderLock = new Object();
    private final List<byte[]> sentWlanPackets = new LinkedList<byte[]>();
    private WlanPacketsSenderThread wlanPacketsSenderThread;
    private final Object gameModeSenderLock = new Object();
    private final List<byte[]> sentGameModePackets = new LinkedList<byte[]>();
    private final List<pspNetMacAddress> sentGameModeMacAddresses = new LinkedList<pspNetMacAddress>();
    private GameModePacketsSenderThread gameModePacketsSenderThread;
    private final Object accessPointSenderLock = new Object();
    private final List<byte[]> sentAccessPointPackets = new LinkedList<byte[]>();
    private final List<EtherFrame> sentAccessPointEtherFrames = new LinkedList<EtherFrame>();
    private AccessPointPacketsSenderThread accessPointPacketsSenderThread;

    public AsyncWlanAdapter(IWlanAdapter wlanAdapter) {
        this.wlanAdapter = wlanAdapter;
    }

    @Override
    public void start() throws IOException {
        this.wlanAdapter.start();
        if (this.wlanPacketsReceiverThread == null) {
            this.wlanPacketsReceiverThread = new WlanPacketsReceiverThread();
            this.wlanPacketsReceiverThread.setName("AsyncWlanAdapter Wlan Packets Receiver Thread");
            this.wlanPacketsReceiverThread.setDaemon(true);
            this.wlanPacketsReceiverThread.start();
        }
        if (this.gameModePacketsReceiverThread == null) {
            this.gameModePacketsReceiverThread = new GameModePacketsReceiverThread();
            this.gameModePacketsReceiverThread.setName("AsyncWlanAdapter GameMode Packets Receiver Thread");
            this.gameModePacketsReceiverThread.setDaemon(true);
            this.gameModePacketsReceiverThread.start();
        }
        if (this.wlanPacketsSenderThread == null) {
            this.wlanPacketsSenderThread = new WlanPacketsSenderThread();
            this.wlanPacketsSenderThread.setName("AsyncWlanAdapter Wlan Packets Sender Thread");
            this.wlanPacketsSenderThread.setDaemon(true);
            this.wlanPacketsSenderThread.start();
        }
        if (this.gameModePacketsSenderThread == null) {
            this.gameModePacketsSenderThread = new GameModePacketsSenderThread();
            this.gameModePacketsSenderThread.setName("AsyncWlanAdapter GameMode Packets Sender Thread");
            this.gameModePacketsSenderThread.setDaemon(true);
            this.gameModePacketsSenderThread.start();
        }
        if (this.accessPointPacketsSenderThread == null) {
            this.accessPointPacketsSenderThread = new AccessPointPacketsSenderThread();
            this.accessPointPacketsSenderThread.setName("AsyncWlanAdapter AccessPoint Packets Sender Thread");
            this.accessPointPacketsSenderThread.setDaemon(true);
            this.accessPointPacketsSenderThread.start();
        }
    }

    @Override
    public void stop() throws IOException {
        if (this.wlanPacketsReceiverThread != null) {
            this.wlanPacketsReceiverThread.exit();
            this.wlanPacketsReceiverThread = null;
        }
        if (this.gameModePacketsReceiverThread != null) {
            this.gameModePacketsReceiverThread.exit();
            this.gameModePacketsReceiverThread = null;
        }
        if (this.wlanPacketsSenderThread != null) {
            this.wlanPacketsSenderThread.exit();
            this.wlanPacketsSenderThread = null;
        }
        if (this.gameModePacketsSenderThread != null) {
            this.gameModePacketsSenderThread.exit();
            this.gameModePacketsSenderThread = null;
        }
        if (this.accessPointPacketsSenderThread != null) {
            this.accessPointPacketsSenderThread.exit();
            this.accessPointPacketsSenderThread = null;
        }
        this.wlanAdapter.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendWlanPacket(byte[] buffer, int offset, int length) {
        if (this.wlanPacketsSenderThread == null) {
            return;
        }
        byte[] sentWlanPacket = Utilities.getArray(buffer, offset, length);
        Object object = this.wlanSenderLock;
        synchronized (object) {
            this.sentWlanPackets.add(sentWlanPacket);
        }
        this.wlanPacketsSenderThread.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendAccessPointPacket(byte[] buffer, int offset, int length, EtherFrame etherFrame) {
        if (this.accessPointPacketsSenderThread == null) {
            return;
        }
        byte[] sentAccessPointPacket = Utilities.getArray(buffer, offset, length);
        EtherFrame sentAccessPointEtherFrame = new EtherFrame(etherFrame);
        Object object = this.accessPointSenderLock;
        synchronized (object) {
            this.sentAccessPointPackets.add(sentAccessPointPacket);
            this.sentAccessPointEtherFrames.add(sentAccessPointEtherFrame);
        }
        this.accessPointPacketsSenderThread.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendGameModePacket(pspNetMacAddress macAddress, byte[] buffer, int offset, int length) {
        if (this.gameModePacketsSenderThread == null) {
            return;
        }
        byte[] sentGameModePacket = Utilities.getArray(buffer, offset, length);
        pspNetMacAddress sentGameModeMacAddress = new pspNetMacAddress(macAddress.macAddress);
        Object object = this.gameModeSenderLock;
        synchronized (object) {
            this.sentGameModePackets.add(sentGameModePacket);
            this.sentGameModeMacAddresses.add(sentGameModeMacAddress);
        }
        this.gameModePacketsSenderThread.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int receiveWlanPacket(byte[] buffer, int offset, int length) {
        byte[] receivedWlanPacket;
        Object object = this.wlanReceiverLock;
        synchronized (object) {
            if (this.receivedWlanPackets.isEmpty()) {
                return -1;
            }
            receivedWlanPacket = this.receivedWlanPackets.remove(0);
        }
        int receivedLength = Math.min(receivedWlanPacket.length, length);
        System.arraycopy(receivedWlanPacket, 0, buffer, offset, receivedLength);
        return receivedLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int receiveGameModePacket(pspNetMacAddress macAddress, byte[] buffer, int offset, int length) {
        pspNetMacAddress receivedGameModeMacAddress;
        byte[] receivedGameModePacket;
        Object object = this.gameModeReceiverLock;
        synchronized (object) {
            if (this.receivedGameModePackets.isEmpty()) {
                return -1;
            }
            receivedGameModePacket = this.receivedGameModePackets.remove(0);
            receivedGameModeMacAddress = this.receivedGameModeMacAddresses.remove(0);
        }
        int receivedLength = Math.min(receivedGameModePacket.length, length);
        System.arraycopy(receivedGameModePacket, 0, buffer, offset, receivedLength);
        macAddress.setMacAddress(receivedGameModeMacAddress.macAddress);
        return receivedLength;
    }

    @Override
    public void wlanScan(String ssid, int[] channels) throws IOException {
        this.wlanAdapter.wlanScan(ssid, channels);
    }

    @Override
    public void sendChatMessage(String message) {
        this.wlanAdapter.sendChatMessage(message);
    }

    private class AccessPointPacketsSenderThread
    extends BaseSenderThread {
        private AccessPointPacketsSenderThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RuntimeContext.setLog4jMDC();
            block5: while (!this.exit) {
                if (!this.waitForSync()) continue;
                while (!this.exit) {
                    byte[] sentAccessPointPacket = null;
                    EtherFrame sentAccessPointEtherFrame = null;
                    Object object = AsyncWlanAdapter.this.accessPointSenderLock;
                    synchronized (object) {
                        if (!AsyncWlanAdapter.this.sentAccessPointPackets.isEmpty()) {
                            sentAccessPointPacket = (byte[])AsyncWlanAdapter.this.sentAccessPointPackets.remove(0);
                            sentAccessPointEtherFrame = (EtherFrame)AsyncWlanAdapter.this.sentAccessPointEtherFrames.remove(0);
                        }
                    }
                    if (sentAccessPointPacket == null) continue block5;
                    try {
                        AsyncWlanAdapter.this.wlanAdapter.sendAccessPointPacket(sentAccessPointPacket, 0, sentAccessPointPacket.length, sentAccessPointEtherFrame);
                    }
                    catch (IOException e) {
                        BaseWlanAdapter.log.error((Object)"sendAccessPointPacket", (Throwable)e);
                    }
                }
            }
        }
    }

    private class GameModePacketsSenderThread
    extends BaseSenderThread {
        private GameModePacketsSenderThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RuntimeContext.setLog4jMDC();
            block5: while (!this.exit) {
                if (!this.waitForSync()) continue;
                while (!this.exit) {
                    byte[] sentGameModePacket = null;
                    pspNetMacAddress sentGameModeMacAddress = null;
                    Object object = AsyncWlanAdapter.this.gameModeSenderLock;
                    synchronized (object) {
                        if (!AsyncWlanAdapter.this.sentGameModePackets.isEmpty()) {
                            sentGameModePacket = (byte[])AsyncWlanAdapter.this.sentGameModePackets.remove(0);
                            sentGameModeMacAddress = (pspNetMacAddress)AsyncWlanAdapter.this.sentGameModeMacAddresses.remove(0);
                        }
                    }
                    if (sentGameModePacket == null) continue block5;
                    try {
                        AsyncWlanAdapter.this.wlanAdapter.sendGameModePacket(sentGameModeMacAddress, sentGameModePacket, 0, sentGameModePacket.length);
                    }
                    catch (IOException e) {
                        BaseWlanAdapter.log.error((Object)"sendGameModePacket", (Throwable)e);
                    }
                }
            }
        }
    }

    private class WlanPacketsSenderThread
    extends BaseSenderThread {
        private WlanPacketsSenderThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RuntimeContext.setLog4jMDC();
            block5: while (!this.exit) {
                if (!this.waitForSync()) continue;
                while (!this.exit) {
                    byte[] sentWlanPacket = null;
                    Object object = AsyncWlanAdapter.this.wlanSenderLock;
                    synchronized (object) {
                        if (!AsyncWlanAdapter.this.sentWlanPackets.isEmpty()) {
                            sentWlanPacket = (byte[])AsyncWlanAdapter.this.sentWlanPackets.remove(0);
                        }
                    }
                    if (sentWlanPacket == null) continue block5;
                    try {
                        AsyncWlanAdapter.this.wlanAdapter.sendWlanPacket(sentWlanPacket, 0, sentWlanPacket.length);
                    }
                    catch (IOException e) {
                        BaseWlanAdapter.log.error((Object)"sendWlanPacket", (Throwable)e);
                    }
                }
            }
        }
    }

    private class GameModePacketsReceiverThread
    extends BaseReceiverThread {
        private final pspNetMacAddress macAddress;

        private GameModePacketsReceiverThread() {
            this.macAddress = new pspNetMacAddress();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RuntimeContext.setLog4jMDC();
            while (!this.exit) {
                try {
                    long start = Scheduler.getNow();
                    int length = AsyncWlanAdapter.this.wlanAdapter.receiveGameModePacket(this.macAddress, this.buffer, 0, this.buffer.length);
                    if (length < 0) {
                        this.delay(start);
                        continue;
                    }
                    byte[] receivedGameModePacket = Utilities.getArray(this.buffer, length);
                    Object object = AsyncWlanAdapter.this.gameModeReceiverLock;
                    synchronized (object) {
                        AsyncWlanAdapter.this.receivedGameModePackets.add(receivedGameModePacket);
                        AsyncWlanAdapter.this.receivedGameModeMacAddresses.add(new pspNetMacAddress(this.macAddress.macAddress));
                    }
                }
                catch (IOException e) {
                    BaseWlanAdapter.log.error((Object)"receiveGameModePacket", (Throwable)e);
                }
            }
        }
    }

    private class WlanPacketsReceiverThread
    extends BaseReceiverThread {
        private WlanPacketsReceiverThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RuntimeContext.setLog4jMDC();
            while (!this.exit) {
                try {
                    boolean added;
                    int size;
                    long start = Scheduler.getNow();
                    int length = AsyncWlanAdapter.this.wlanAdapter.receiveWlanPacket(this.buffer, 0, this.buffer.length);
                    if (length < 0) {
                        this.delay(start);
                        continue;
                    }
                    byte[] receivedWlanPacket = Utilities.getArray(this.buffer, length);
                    Object object = AsyncWlanAdapter.this.wlanReceiverLock;
                    synchronized (object) {
                        size = AsyncWlanAdapter.this.receivedWlanPackets.size();
                        AsyncWlanAdapter.this.receivedWlanPackets.add(receivedWlanPacket);
                        added = true;
                    }
                    if (!added) {
                        if (!BaseWlanAdapter.log.isDebugEnabled()) continue;
                        BaseWlanAdapter.log.debug((Object)String.format("Dropped packet, receivedWlanPackets size=%d", size));
                        continue;
                    }
                    if (size > 100) {
                        if (size % 10 != 0) continue;
                        BaseWlanAdapter.log.error((Object)String.format("Extremely slow processing of network traffic (%d packets waiting in receive queue)", size));
                        continue;
                    }
                    if (size > 10) {
                        if (size % 10 != 0) continue;
                        BaseWlanAdapter.log.warn((Object)String.format("Slow processing of network traffic (%d packets waiting in receive queue)", size));
                        continue;
                    }
                    if (!BaseWlanAdapter.log.isTraceEnabled()) continue;
                    BaseWlanAdapter.log.trace((Object)String.format("receivedWlanPackets size=%d", size));
                }
                catch (IOException e) {
                    BaseWlanAdapter.log.error((Object)"receiveWlanPacket", (Throwable)e);
                }
            }
        }
    }

    private abstract class BaseSenderThread
    extends BaseThread {
        protected final Semaphore sync;
        private static final int delay = 1000;

        private BaseSenderThread() {
            this.sync = new Semaphore(0);
        }

        protected boolean waitForSync() {
            while (true) {
                try {
                    int availablePermits = this.sync.drainPermits();
                    if (availablePermits <= 0 && !this.sync.tryAcquire(1000L, TimeUnit.MILLISECONDS)) {
                        return false;
                    }
                }
                catch (InterruptedException e) {
                    if (!BaseWlanAdapter.log.isDebugEnabled()) continue;
                    BaseWlanAdapter.log.debug((Object)String.format("BaseSenderThread waitForSync %s", e));
                    continue;
                }
                break;
            }
            return true;
        }

        public void sync() {
            this.sync.release();
        }

        @Override
        public void exit() {
            this.sync();
            super.exit();
        }
    }

    private abstract class BaseReceiverThread
    extends BaseThread {
        protected final byte[] buffer;
        private static final int delay = 10000;

        private BaseReceiverThread() {
            this.buffer = new byte[10000];
        }

        void delay(long start) {
            int duration = (int)(Scheduler.getNow() - start);
            if (duration < 10000) {
                Utilities.sleep(10000 - duration);
            }
        }
    }

    private abstract class BaseThread
    extends Thread {
        protected volatile boolean exit;

        private BaseThread() {
        }

        public void exit() {
            this.exit = true;
        }
    }
}

